package net.minecraft.entity;

import jamezo97.clonecraft.CloneCraftUtils;
import jamezo97.clonecraft.Reflect;
import jamezo97.clonecraft.Synchronize.DataSynchronizer;
import jamezo97.clonecraft.Synchronize.SyncData;
import jamezo97.clonecraft.Synchronize.Synchronizable;
import jamezo97.clonecraft.dna.Gene;
import jamezo97.clonecraft.entity.EntityModifiable;
import jamezo97.clonecraft.network.Handler15Synchronize;
import jamezo97.clonecraft.network.NetworkHandler;

import java.util.ArrayList;
import java.util.Collection;

import net.minecraft.block.material.Material;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeInstance;
import net.minecraft.entity.ai.attributes.BaseAttributeMap;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemSaddle;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.CombatTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

import org.apache.commons.lang3.ArrayUtils;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class CCEntityAnything extends EntityModifiable implements Synchronizable{


	int otherEntityId;

	public EntityLiving theEntity;

	public DataSynchronizer sync;



	public CCEntityAnything(World par1World) {
		super(par1World);
		sync = new DataSynchronizer(this, false);
	}

	public float getEyeHeight() {

		float eye;
		if(theEntity != null){float scaling = Gene.getGeneScaling(this);;
		eye = theEntity.getEyeHeight();
		eye *= scaling;
		}else{eye = super.getEyeHeight();}
		return eye;
	}




	@Override
	public float getBaseStepHeight() {
		return baseStepHeight;
	}

	public CCEntityAnything(World world, EntityLiving copyFrom){
		this(world);
		EntityLiving copied = (EntityLiving)EntityList.createEntityByID(EntityList.getEntityID(copyFrom), world);
		copied.copyDataFrom(copyFrom, true);
		setEntity(copied);
	}

	public CCEntityAnything(World world, int id){
		this(world);
		EntityLiving copied = (EntityLiving)EntityList.createEntityByID(id, world);
		setEntity(copied);
	}

	public void setEntity(int id){
		EntityLiving entity = (EntityLiving)EntityList.createEntityByID(id, worldObj);
		setEntity(entity);
	}

	boolean hasSetlocationAndAngles = false;

	public void setEntity(EntityLiving entity){
		if(entity == null){setDead(); return;}
		entity.entityId = entityId;
		this.theEntity = entity;
		Reflect.set(Reflect.lookHelper, theEntity, getLookHelper());
		this.otherEntityId = EntityList.getEntityID(theEntity);

		baseStepHeight = theEntity.stepHeight;
		baseSizeX = theEntity.width;
		baseSizeY = theEntity.height;
		baseYOffset = theEntity.yOffset;

		if(hasSetlocationAndAngles){
			hasSetlocationAndAngles = false;
			theEntity.setLocationAndAngles(posX, posY, posZ, rotationPitch, rotationYaw);
			theEntity.setVelocity(motionX, motionY, motionZ);
		}else{
			super.setLocationAndAngles(theEntity.posX, theEntity.posY, theEntity.posZ, theEntity.rotationPitch, theEntity.rotationYaw);
			motionX = theEntity.motionX;
			motionY = theEntity.motionY;
			motionZ = theEntity.motionZ;
		}

		this.maxHurtTime = theEntity.maxHurtTime;
		this.maxHurtResistantTime = theEntity.maxHurtResistantTime;

		this.dataWatcher = theEntity.dataWatcher;

		this.setSize(theEntity.width, theEntity.height);

		this.velocityChanged = true;
	}

	float baseStepHeight;

	@Override
	public void writeSpawnData(ByteArrayDataOutput data) {
		super.writeSpawnData(data);
		data.writeInt(otherEntityId);
		data.writeFloat(this.rotationPitch);
		data.writeFloat(this.rotationYaw);
	}


	@Override
	public void readSpawnData(ByteArrayDataInput data) {
		super.readSpawnData(data);
		this.setEntity(data.readInt());
		this.rotationPitch = data.readFloat();
		this.rotationYaw = data.readFloat();
	}

	@Override
	public DataSynchronizer getSyncer() {
		return sync;
	}

	@Override
	public void sendData(SyncData[] data) {
		Handler15Synchronize handler = new Handler15Synchronize(this, data);
		handler.sendToClients(currentWatchingPlayers);
	}

	@Override
	public boolean canSet(int id, Object value, Object setter) {
		if(worldObj.isRemote){
			return true;
		}
		return false;
	}

	@Override
	public void anteSet(int id, Object value) {

	}

	@Override
	public void postSet(int id, Object value) {
		if(id == 0){
			setEntity(otherEntityId);
		}
	}




	@Override
	public void onUpdate() {

		//		System.out.println(worldObj.isRemote + ":" + entityId);
		//Don't tick on the first tick. This solves all sorts of issues, such as
		//the transformation between the unmodified and this version of the entity
		//is smoother, and they don't sink into the ground :) Entities aren't meant to be moved
		//within the first tick of their existence, excluding arrows for some reason... This solves
		//that issue. Damn, what a lot of work for this one line of code.
		if(this.ticksExisted == 1)return;

		hasSetlocationAndAngles = false;
		this.prevPosX = posX;
		this.prevPosY = posY;
		this.prevPosZ = posZ;

		getGenePool().onUpdate();

		if(theEntity != null){
			theEntity.entityId = entityId;
			theEntity.onUpdate();
			super.setPosition(theEntity.posX, theEntity.posY, theEntity.posZ);
			motionX = theEntity.motionX;
			motionY = theEntity.motionY;
			motionZ = theEntity.motionZ;
			
			if(worldObj.isRemote){
				updateServer();
			}

			super.setRotation(theEntity.rotationYaw, theEntity.rotationPitch);


			if(theEntity.isDead){
				this.setDead();
			}

		}else if(!worldObj.isRemote){
			this.setDead();
		}
		if(!worldObj.isRemote){
			getSyncer().synchronize();
			updateMyDataToNewWatchers();
		}
	}
	
	@SideOnly(value = Side.CLIENT)
	public void updateServer(){
		theEntity.serverPosX = this.serverPosX;
		theEntity.serverPosY = this.serverPosY;
		theEntity.serverPosZ = this.serverPosZ;
	}



	@Override
	public boolean shouldApplySizeChange() {
		return theEntity != null && !excludeSizeChange.contains(theEntity.getClass());
	}

	@Override
	protected void setSize(float par1, float par2) {
		super.setSize(par1, par2);
		if(theEntity != null){
			theEntity.setSize(par1, par2);
		}
	}

	@Override
	protected void setRotation(float par1, float par2) {
		super.setRotation(par1, par2);
		if(theEntity != null){
			theEntity.setRotation(par1, par2);
		}

	}

	@Override
	public void setPosition(double par1, double par3, double par5) {
		super.setPosition(par1, par3, par5);
		if(theEntity != null){
			theEntity.setPosition(par1, par3, par5);
		}

	}

	@Override
	public void setPositionAndRotation(double par1, double par3, double par5,float par7, float par8) {
		super.setPositionAndRotation(par1, par3, par5, par7, par8);
		if(theEntity != null){
			theEntity.setPositionAndRotation(par1, par3, par5, par7, par8);
		}
	}










	EntityPlayer[] currentWatchingPlayers = new EntityPlayer[0];

	EntityPlayer[] lastWatchingPlayers = new EntityPlayer[0];

	public void updateMyDataToNewWatchers(){
		if(ticksExisted % 5 == 0){
			EntityTrackerEntry tracker = CloneCraftUtils.getTracker(this);
			if(tracker != null){
				lastWatchingPlayers = currentWatchingPlayers.clone();
				currentWatchingPlayers = (EntityPlayer[])tracker.trackingPlayers.toArray(new EntityPlayer[tracker.trackingPlayers.size()]);
				for(int a = 0; a < currentWatchingPlayers.length; a++){
					if(!ArrayUtils.contains(lastWatchingPlayers, currentWatchingPlayers[a])){
						updateAllData(currentWatchingPlayers[a]);
					}
				}
			}
		}
	}

	private Packet previousPacketSyncDataAll;
	SyncData[] previousSyncDataAll = null;

	private void updateAllData(EntityPlayer... entityPlayer) {
		SyncData[] data = sync.getSyncDataForAllValues();
		if(data != null){
			Packet send = null;
			if(previousSyncDataAll == data){
				send = previousPacketSyncDataAll;
			}else{
				send = new Handler15Synchronize(this, data).createPacket(Side.CLIENT);
				previousPacketSyncDataAll = send;
			}
			NetworkHandler.sendPacketToPlayers(entityPlayer, send);
		}
		previousSyncDataAll = data;
	}





	@Override
	public void writeEntityToNBT(NBTTagCompound nbt) {
		super.writeEntityToNBT(nbt);
		NBTTagCompound otherEntity = new NBTTagCompound();
		if(theEntity != null){
			theEntity.writeToNBT(otherEntity);

			nbt.setTag("OtherEntity", otherEntity);
			nbt.setInteger("otherEntityId", otherEntityId);
		}

	}

	@Override
	public void readEntityFromNBT(NBTTagCompound nbt) {
		super.readEntityFromNBT(nbt);

		try{
			if(nbt.hasKey("otherEntityId")){
				Entity e = EntityList.createEntityByID(nbt.getInteger("otherEntityId"), worldObj);
				if(e != null && e instanceof EntityLiving){
					e.readFromNBT(nbt.getCompoundTag("OtherEntity"));
					setEntity((EntityLiving)e);
				}else{
					setDead();
				}
			}else{
				setDead();
			}
		}catch(Exception e){
			e.printStackTrace();
		}

	}






	public ItemStack getHeldItem(){
		if(theEntity != null){return theEntity.getHeldItem();}else{return super.getHeldItem();}
	}
	public ItemStack getCurrentItemOrArmor(int par1) {
		if(theEntity != null){return theEntity.getCurrentItemOrArmor(par1);}else{return super.getCurrentItemOrArmor(par1);}
	}
	public ItemStack func_130225_q(int i){
		if(theEntity != null){return theEntity.getCurrentItemOrArmor(i+1);}else{return super.getCurrentItemOrArmor(i+1);}
	}
	public void setCurrentItemOrArmor(int par1, ItemStack par2ItemStack){
		if(theEntity != null){theEntity.setCurrentItemOrArmor(par1, par2ItemStack);}else{super.setCurrentItemOrArmor(par1, par2ItemStack);}
	}
	public ItemStack[] getLastActiveItems() {
		if(theEntity != null){return theEntity.getLastActiveItems();}else{return super.getLastActiveItems();}
	}

	public boolean isChild() {
		if(theEntity != null){return theEntity.isChild();}else{return super.isChild();}
	}
	public void clearActivePotions() {
		if(theEntity != null){theEntity.clearActivePotions();}else{super.clearActivePotions();}
	}
	public Collection getActivePotionEffects() {
		if(theEntity != null){return theEntity.getActivePotionEffects();}else{return super.getActivePotionEffects();}
	}
	public boolean isPotionActive(int par1) {
		if(theEntity != null){return theEntity.isPotionActive(par1);}else{return super.isPotionActive(par1);}
	}
	public boolean isPotionActive(Potion par1Potion) {
		if(theEntity != null){return theEntity.isPotionActive(par1Potion);}else{return super.isPotionActive(par1Potion);}
	}
	public PotionEffect getActivePotionEffect(Potion par1Potion) {
		if(theEntity != null){return theEntity.getActivePotionEffect(par1Potion);}else{return super.getActivePotionEffect(par1Potion);}
	}
	public void addPotionEffect(PotionEffect par1PotionEffect) {
		if(theEntity != null){theEntity.addPotionEffect(par1PotionEffect);}else{super.addPotionEffect(par1PotionEffect);}
	}
	public boolean isPotionApplicable(PotionEffect par1PotionEffect) {
		if(theEntity != null){return theEntity.isPotionApplicable(par1PotionEffect);}else{return super.isPotionApplicable(par1PotionEffect);}
	}
	public boolean isEntityUndead() {
		if(theEntity != null){return theEntity.isEntityUndead();}else{return super.isEntityUndead();}
	}
	public void removePotionEffectClient(int par1) {
		if(theEntity != null){theEntity.removePotionEffectClient(par1);}else{super.removePotionEffectClient(par1);}
	}
	public void removePotionEffect(int par1) {
		if(theEntity != null){theEntity.removePotionEffect(par1);}else{super.removePotionEffect(par1);}
	}
	protected void onNewPotionEffect(PotionEffect par1PotionEffect) {
		if(theEntity != null){theEntity.onNewPotionEffect(par1PotionEffect);}else{super.onNewPotionEffect(par1PotionEffect);}
	}
	protected void onChangedPotionEffect(PotionEffect par1PotionEffect, boolean par2) {
		if(theEntity != null){theEntity.onChangedPotionEffect(par1PotionEffect, par2);}else{super.onChangedPotionEffect(par1PotionEffect, par2);}
	}
	protected void onFinishedPotionEffect(PotionEffect par1PotionEffect) {
		if(theEntity != null){theEntity.onFinishedPotionEffect(par1PotionEffect);}else{super.onFinishedPotionEffect(par1PotionEffect);}
	}
	public void heal(float par1) {
		if(theEntity != null){theEntity.heal(par1);}else{super.heal(par1);}
	}
	public void setHealth(float par1) {
		if(theEntity != null){theEntity.setHealth(par1);}else{super.setHealth(par1);}
	}
	public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
		if(theEntity != null){return theEntity.attackEntityFrom(par1DamageSource, par2);}else{return super.attackEntityFrom(par1DamageSource, par2);}
	}
	public void renderBrokenItemStack(ItemStack par1ItemStack) {
		if(theEntity != null){theEntity.renderBrokenItemStack(par1ItemStack);}else{super.renderBrokenItemStack(par1ItemStack);}
	}

	public void onDeath(DamageSource par1DamageSource) {
		if(theEntity != null){theEntity.onDeath(par1DamageSource);}else{super.onDeath(par1DamageSource);}
	}
	public void knockBack(Entity par1Entity, float par2, double par3, double par5) {
		if(theEntity != null){theEntity.knockBack(par1Entity, par2, par3, par5);}else{super.knockBack(par1Entity, par2, par3, par5);}
	}
	protected String getHurtSound() {
		if(theEntity != null){return theEntity.getHurtSound();}else{return super.getHurtSound();}
	}
	protected String getDeathSound() {
		if(theEntity != null){return theEntity.getDeathSound();}else{return super.getDeathSound();}
	}
	protected void dropRareDrop(int par1) {
		if(theEntity != null){theEntity.dropRareDrop(par1);}else{super.dropRareDrop(par1);}
	}
	public boolean isOnLadder() {
		if(theEntity != null){return theEntity.isOnLadder();}else{return super.isOnLadder();}
	}
	public boolean isEntityAlive() {
		if(theEntity != null){return theEntity.isEntityAlive();}else{return super.isEntityAlive();}
	}
	protected void fall(float par1) {
		if(theEntity != null){theEntity.fall(par1);}else{super.fall(par1);}
	}
	public void performHurtAnimation() {
		if(theEntity != null){theEntity.performHurtAnimation();
		this.hurtTime = this.maxHurtTime = theEntity.hurtTime;
		this.attackedAtYaw = theEntity.attackedAtYaw;

		}else{super.performHurtAnimation();}
	}
	public int getTotalArmorValue() {
		if(theEntity != null){return theEntity.getTotalArmorValue();}else{return super.getTotalArmorValue();}
	}
	protected void damageArmor(float par1) {
		if(theEntity != null){theEntity.damageArmor(par1);}else{super.damageArmor(par1);}
	}
	protected float applyArmorCalculations(DamageSource par1DamageSource, float par2) {
		if(theEntity != null){return theEntity.applyArmorCalculations(par1DamageSource, par2);}else{return super.applyArmorCalculations(par1DamageSource, par2);}
	}
	protected float applyPotionDamageCalculations(DamageSource par1DamageSource, float par2) {
		if(theEntity != null){return theEntity.applyPotionDamageCalculations(par1DamageSource, par2);}else{return super.applyPotionDamageCalculations(par1DamageSource, par2);}
	}
	protected void damageEntity(DamageSource par1DamageSource, float par2) {
		if(theEntity != null){theEntity.damageEntity(par1DamageSource, par2);}else{super.damageEntity(par1DamageSource, par2);}
	}
	public CombatTracker func_110142_aN() {
		if(theEntity != null){return theEntity.func_110142_aN();}else{return super.func_110142_aN();}
	}
	public EntityLivingBase func_94060_bK() {
		if(theEntity != null){return theEntity.func_94060_bK();}else{return super.func_94060_bK();}
	}
	public void swingItem() {
		if(theEntity != null){theEntity.swingItem();}else{super.swingItem();}
	}
	public void handleHealthUpdate(byte par1) {
		if(theEntity != null){theEntity.handleHealthUpdate(par1);}else{super.handleHealthUpdate(par1);}
	}
	protected void kill() {
		super.kill();
		if(theEntity != null){theEntity.kill();}
	}
	protected void updateArmSwingProgress() {
		if(theEntity != null){theEntity.updateArmSwingProgress();}else{super.updateArmSwingProgress();}
	}
	public AttributeInstance getEntityAttribute(Attribute par1Attribute) {
		if(theEntity != null){return theEntity.getEntityAttribute(par1Attribute);}else{return super.getEntityAttribute(par1Attribute);}
	}
	public BaseAttributeMap func_110140_aT() {
		if(theEntity != null){return theEntity.getAttributeMap();}else{return super.getAttributeMap();}
	}
	public EnumCreatureAttribute getCreatureAttribute() {
		if(theEntity != null){return theEntity.getCreatureAttribute();}else{return super.getCreatureAttribute();}
	}
	public void setSprinting(boolean par1) {
		if(theEntity != null){theEntity.setSprinting(par1);}else{super.setSprinting(par1);}
	}
	protected float getSoundVolume() {
		if(theEntity != null){return theEntity.getSoundVolume();}else{return super.getSoundVolume();}
	}
	protected float getSoundPitch() {
		if(theEntity != null){return theEntity.getSoundPitch();}else{return super.getSoundPitch();}
	}
	protected boolean isMovementBlocked() {
		if(theEntity != null){return theEntity.isMovementBlocked();}else{return super.isMovementBlocked();}
	}
	public void setPositionAndUpdate(double par1, double par3, double par5) {
		{super.setPositionAndUpdate(par1, par3, par5);}
		if(theEntity != null){theEntity.setPositionAndUpdate(par1, par3, par5);}
	}
	public void dismountEntity(Entity par1Entity) {
		if(theEntity != null){theEntity.dismountEntity(par1Entity);}else{super.dismountEntity(par1Entity);}
	}
	protected void jump() {
		if(theEntity != null){theEntity.jump();}else{super.jump();}
	}
	public void moveEntityWithHeading(float par1, float par2) {
		{super.moveEntityWithHeading(par1, par2);}
		if(theEntity != null){theEntity.moveEntityWithHeading(par1, par2);}
	}
	public float getAIMoveSpeed() {
		if(theEntity != null){return theEntity.getAIMoveSpeed();}else{return super.getAIMoveSpeed();}
	}
	public boolean attackEntityAsMob(Entity par1Entity) {
		if(theEntity != null){return theEntity.attackEntityAsMob(par1Entity);}else{return super.attackEntityAsMob(par1Entity);}
	}
	public boolean isPlayerSleeping() {
		if(theEntity != null){return theEntity.isPlayerSleeping();}else{return super.isPlayerSleeping();}
	}
	protected void collideWithNearbyEntities() {
		if(theEntity != null){theEntity.collideWithNearbyEntities();}else{super.collideWithNearbyEntities();}
	}
	protected void collideWithEntity(Entity par1Entity) {
		if(theEntity != null){theEntity.collideWithEntity(par1Entity);}else{super.collideWithEntity(par1Entity);}
	}
	public void updateRidden() {
		if(theEntity != null){theEntity.updateRidden();}else{super.updateRidden();}
	}
	public void setPositionAndRotation2(double par1, double par3, double par5, float par7, float par8, int par9) {
		super.setPositionAndRotation2(par1, par3, par5, par7, par8, par9);
		if(theEntity != null){theEntity.setPositionAndRotation2(par1, par3, par5, par7, par8, par9);}
	}
	protected void updateAITick() {
		if(theEntity != null){theEntity.updateAITick();}else{super.updateAITick();}
	}
	public void setJumping(boolean par1) {
		if(theEntity != null){theEntity.setJumping(par1);}else{super.setJumping(par1);}
	}
	public void onItemPickup(Entity par1Entity, int par2) {
		if(theEntity != null){theEntity.onItemPickup(par1Entity, par2);}else{super.onItemPickup(par1Entity, par2);}
	}
	public boolean canEntityBeSeen(Entity par1Entity) {
		if(theEntity != null){return theEntity.canEntityBeSeen(par1Entity);}else{return super.canEntityBeSeen(par1Entity);}
	}
	public Vec3 getLookVec() {
		if(theEntity != null){return theEntity.getLookVec();}else{return super.getLookVec();}
	}
	public Vec3 getLook(float par1) {
		if(theEntity != null){return theEntity.getLook(par1);}else{return super.getLook(par1);}
	}
	public float getSwingProgress(float par1) {
		if(theEntity != null){return theEntity.getSwingProgress(par1);}else{return super.getSwingProgress(par1);}
	}
	public Vec3 getPosition(float par1) {
		if(theEntity != null){return theEntity.getPosition(par1);}else{return super.getPosition(par1);}
	}
	public MovingObjectPosition rayTrace(double par1, float par3) {
		if(theEntity != null){return theEntity.rayTrace(par1, par3);}else{return super.rayTrace(par1, par3);}
	}
	public boolean isClientWorld() {
		if(theEntity != null){return theEntity.isClientWorld();}else{return super.isClientWorld();}
	}
	public boolean canBeCollidedWith() {
		if(theEntity != null){return theEntity.canBeCollidedWith();}else{return super.canBeCollidedWith();}
	}
	public boolean canBePushed() {
		if(theEntity != null){return theEntity.canBePushed();}else{return super.canBePushed();}
	}

	protected void setBeenAttacked() {
		if(theEntity != null){theEntity.setBeenAttacked();}else{super.setBeenAttacked();}
	}
	public float getRotationYawHead() {
		if(theEntity != null){return theEntity.getRotationYawHead();}else{return super.getRotationYawHead();}
	}
	public void setRotationYawHead(float par1) {
		if(theEntity != null){theEntity.setRotationYawHead(par1);}else{super.setRotationYawHead(par1);}
	}
	public float func_110139_bj() {
		if(theEntity != null){return theEntity.getAbsorptionAmount();}else{return super.getAbsorptionAmount();}
	}
	public void func_110149_m(float par1) {
		if(theEntity != null){theEntity.setAbsorptionAmount(par1);}else{super.setAbsorptionAmount(par1);}
	}
	public Team getTeam() {
		if(theEntity != null){return theEntity.getTeam();}else{return super.getTeam();}
	}
	public boolean isOnSameTeam(EntityLivingBase par1EntityLivingBase) {
		if(theEntity != null){return theEntity.isOnSameTeam(par1EntityLivingBase);}else{return super.isOnSameTeam(par1EntityLivingBase);}
	}
	public boolean isOnTeam(Team par1Team) {
		if(theEntity != null){return theEntity.isOnTeam(par1Team);}else{return super.isOnTeam(par1Team);}
	}
	public void curePotionEffects(ItemStack curativeItem) {
		if(theEntity != null){theEntity.curePotionEffects(curativeItem);}else{super.curePotionEffects(curativeItem);}
	}
	public boolean shouldRiderFaceForward(EntityPlayer player) {
		if(theEntity != null){return theEntity.shouldRiderFaceForward(player);}else{return super.shouldRiderFaceForward(player);}
	}
	public DataWatcher getDataWatcher() {
		if(theEntity != null){return theEntity.getDataWatcher();}else{return super.getDataWatcher();}
	}
	public boolean equals(Object par1Obj) {
		return super.equals(par1Obj);
		//		if(theEntity != null){return theEntity.equals(par1Obj);}else{}
	}
	public int hashCode() {
		return super.hashCode();
	}
	protected void preparePlayerToSpawn() {
		if(theEntity != null){theEntity.preparePlayerToSpawn();}else{super.preparePlayerToSpawn();}
	}
	public void setDead() {
		if(theEntity != null){theEntity.setDead();}else{super.setDead();}
		super.setDead();
	}
	public void setAngles(float par1, float par2) {
		{super.setAngles(par1, par2);}
		if(theEntity != null){theEntity.setAngles(par1, par2);}
	}
	public int getMaxInPortalTime() {
		if(theEntity != null){return theEntity.getMaxInPortalTime();}else{return super.getMaxInPortalTime();}
	}
	protected void setOnFireFromLava() {
		if(theEntity != null){theEntity.setOnFireFromLava();}else{super.setOnFireFromLava();}
	}
	public void setFire(int par1) {
		if(theEntity != null){theEntity.setFire(par1);}else{super.setFire(par1);}
	}
	public void extinguish() {
		if(theEntity != null){theEntity.extinguish();}else{super.extinguish();}
	}
	public boolean isOffsetPositionInLiquid(double par1, double par3, double par5) {
		if(theEntity != null){return theEntity.isOffsetPositionInLiquid(par1, par3, par5);}else{return super.isOffsetPositionInLiquid(par1, par3, par5);}
	}
	public void moveEntity(double par1, double par3, double par5) {
		{super.moveEntity(par1, par3, par5);}
		if(theEntity != null){theEntity.moveEntity(par1, par3, par5);}
	}
	protected void doBlockCollisions() {
		if(theEntity != null){theEntity.doBlockCollisions();}else{super.doBlockCollisions();}
	}
	protected void playStepSound(int par1, int par2, int par3, int par4) {
		if(theEntity != null){theEntity.playStepSound(par1, par2, par3, par4);}else{super.playStepSound(par1, par2, par3, par4);}
	}
	public void playSound(String par1Str, float par2, float par3) {
		if(theEntity != null){theEntity.playSound(par1Str, par2, par3);}else{super.playSound(par1Str, par2, par3);}
	}
	protected boolean canTriggerWalking() {
		if(theEntity != null){return theEntity.canTriggerWalking();}else{return super.canTriggerWalking();}
	}
	public AxisAlignedBB getBoundingBox() {
		if(theEntity != null){return theEntity.getBoundingBox();}else{return super.getBoundingBox();}
	}
	protected void dealFireDamage(int par1) {
		if(theEntity != null){theEntity.dealFireDamage(par1);}else{super.dealFireDamage(par1);}
	}
	public boolean isWet() {
		if(theEntity != null){return theEntity.isWet();}else{return super.isWet();}
	}
	public boolean isInWater() {
		if(theEntity != null){return theEntity.isInWater();}else{return super.isInWater();}
	}
	public boolean handleWaterMovement() {
		if(theEntity != null){return theEntity.handleWaterMovement();}else{return super.handleWaterMovement();}
	}
	public boolean isInsideOfMaterial(Material par1Material) {
		if(theEntity != null){return theEntity.isInsideOfMaterial(par1Material);}else{return super.isInsideOfMaterial(par1Material);}
	}
	public boolean handleLavaMovement() {
		if(theEntity != null){return theEntity.handleLavaMovement();}else{return super.handleLavaMovement();}
	}
	public void moveFlying(float par1, float par2, float par3) {
		if(theEntity != null){theEntity.moveFlying(par1, par2, par3);}else{super.moveFlying(par1, par2, par3);}
	}
	public int getBrightnessForRender(float par1) {
		if(theEntity != null){return theEntity.getBrightnessForRender(par1);}else{return super.getBrightnessForRender(par1);}
	}
	public float getBrightness(float par1) {
		if(theEntity != null){return theEntity.getBrightness(par1);}else{return super.getBrightness(par1);}
	}
	public void setWorld(World par1World) {
		if(theEntity != null){theEntity.setWorld(par1World);}else{super.setWorld(par1World);}
	}
	public void setLocationAndAngles(double par1, double par3, double par5, float par7, float par8) {
		hasSetlocationAndAngles = true;
		super.setLocationAndAngles(par1, par3, par5, par7, par8);
		if(theEntity != null){theEntity.setLocationAndAngles(par1, par3, par5, par7, par8);}
	}
	public float getDistanceToEntity(Entity par1Entity) {
		if(theEntity != null){return theEntity.getDistanceToEntity(par1Entity);}else{return super.getDistanceToEntity(par1Entity);}
	}
	public double getDistanceSq(double par1, double par3, double par5) {
		if(theEntity != null){return theEntity.getDistanceSq(par1, par3, par5);}else{return super.getDistanceSq(par1, par3, par5);}
	}
	public double getDistance(double par1, double par3, double par5) {
		if(theEntity != null){return theEntity.getDistance(par1, par3, par5);}else{return super.getDistance(par1, par3, par5);}
	}
	public double getDistanceSqToEntity(Entity par1Entity) {
		if(theEntity != null){return theEntity.getDistanceSqToEntity(par1Entity);}else{return super.getDistanceSqToEntity(par1Entity);}
	}
	public void onCollideWithPlayer(EntityPlayer par1EntityPlayer) {
		if(theEntity != null){theEntity.onCollideWithPlayer(par1EntityPlayer);}else{super.onCollideWithPlayer(par1EntityPlayer);}
	}
	public void applyEntityCollision(Entity par1Entity) {
		if(theEntity != null){theEntity.applyEntityCollision(par1Entity);}else{super.applyEntityCollision(par1Entity);}
	}
	public void addVelocity(double par1, double par3, double par5) {
		{super.addVelocity(par1, par3, par5);}
		if(theEntity != null){theEntity.addVelocity(par1, par3, par5);}
	}
	public void addToPlayerScore(Entity par1Entity, int par2) {
		if(theEntity != null){theEntity.addToPlayerScore(par1Entity, par2);}else{super.addToPlayerScore(par1Entity, par2);}
	}
	public boolean writeMountToNBT(NBTTagCompound par1nbtTagCompound) {
		return super.writeMountToNBT(par1nbtTagCompound);
	}
	public boolean writeToNBTOptional(NBTTagCompound par1nbtTagCompound) {
		return super.writeToNBTOptional(par1nbtTagCompound);
		//		if(theEntity != null){return theEntity.addEntityID(par1nbtTagCompound);}else{return super.addEntityID(par1nbtTagCompound);}
	}
	public void setVelocity(double par1, double par3, double par5) {
		{super.setVelocity(par1, par3, par5);}
		if(theEntity != null){theEntity.setVelocity(par1, par3, par5);}
	}
	protected boolean interact(EntityPlayer par1EntityPlayer) {
		if(theEntity != null){

			if(theEntity instanceof EntityPig){
				EntityPig pig = (EntityPig)theEntity;
				boolean ret = pig.interact(par1EntityPlayer);
				if(ret && par1EntityPlayer.ridingEntity == pig){
					par1EntityPlayer.mountEntity(this);
				}else{
					if(par1EntityPlayer.getCurrentEquippedItem() != null && par1EntityPlayer.getCurrentEquippedItem().getItem() instanceof ItemSaddle){
						((ItemSaddle)par1EntityPlayer.getCurrentEquippedItem().getItem()).itemInteractionForEntity(par1EntityPlayer.capabilities.isCreativeMode?par1EntityPlayer.getCurrentEquippedItem().copy():par1EntityPlayer.getCurrentEquippedItem(), par1EntityPlayer, theEntity);
					}
				}
				return ret;
			}else{
				return theEntity.interact(par1EntityPlayer);
			}
		}else{
			return super.interact(par1EntityPlayer);
		}
	}

	/*	public void writeToNBT(NBTTagCompound par1nbtTagCompound) {
		if(theEntity != null){theEntity.writeToNBT(par1nbtTagCompound);}else{super.writeToNBT(par1nbtTagCompound);}
	}
	public void readFromNBT(NBTTagCompound par1nbtTagCompound) {
		if(theEntity != null){theEntity.readFromNBT(par1nbtTagCompound);}else{super.readFromNBT(par1nbtTagCompound);}
	}
	protected boolean func_142008_O() {
		if(theEntity != null){return theEntity.func_142008_O();}else{return super.func_142008_O();}
	}
	public void func_110123_P() {
		if(theEntity != null){theEntity.func_110123_P();}else{super.func_110123_P();}
	}
	protected NBTTagList newDoubleNBTList(double... par1ArrayOfDouble) {
		if(theEntity != null){return theEntity.newDoubleNBTList(par1ArrayOfDouble);}else{return super.newDoubleNBTList(par1ArrayOfDouble);}
	}
	protected NBTTagList newFloatNBTList(float... par1ArrayOfFloat) {
		if(theEntity != null){return theEntity.newFloatNBTList(par1ArrayOfFloat);}else{return super.newFloatNBTList(par1ArrayOfFloat);}
	}
	public float getShadowSize() {
		if(theEntity != null){return theEntity.getShadowSize();}else{return super.getShadowSize();}
	}
	public EntityItem dropItem(int par1, int par2) {
		if(theEntity != null){return theEntity.dropItem(par1, par2);}else{return super.dropItem(par1, par2);}
	}
	public EntityItem dropItemWithOffset(int par1, int par2, float par3) {
		if(theEntity != null){return theEntity.dropItemWithOffset(par1, par2, par3);}else{return super.dropItemWithOffset(par1, par2, par3);}
	}
	public EntityItem entityDropItem(ItemStack par1ItemStack, float par2) {
		if(theEntity != null){return theEntity.entityDropItem(par1ItemStack, par2);}else{return super.entityDropItem(par1ItemStack, par2);}
	}
	public boolean isEntityInsideOpaqueBlock() {
		if(theEntity != null){return theEntity.isEntityInsideOpaqueBlock();}else{return super.isEntityInsideOpaqueBlock();}
	}
	public AxisAlignedBB getCollisionBox(Entity par1Entity) {
		if(theEntity != null){return theEntity.getCollisionBox(par1Entity);}else{return super.getCollisionBox(par1Entity);}
	}
	public void updateRiderPosition() {
		if(theEntity != null){theEntity.updateRiderPosition();}else{super.updateRiderPosition();}
	}
	public double getYOffset() {
		if(theEntity != null){return theEntity.getYOffset();}else{return super.getYOffset();}
	}
	public double getMountedYOffset() {
		if(theEntity != null){return theEntity.getMountedYOffset();}else{return super.getMountedYOffset();}
	}
	public void mountEntity(Entity par1Entity) {
		if(theEntity != null){theEntity.mountEntity(par1Entity);}else{super.mountEntity(par1Entity);}
	}
	public float getCollisionBorderSize() {
		if(theEntity != null){return theEntity.getCollisionBorderSize();}else{return super.getCollisionBorderSize();}
	}
	public void setInPortal() {
		if(theEntity != null){theEntity.setInPortal();}else{super.setInPortal();}
	}
	public int getPortalCooldown() {
		if(theEntity != null){return theEntity.getPortalCooldown();}else{return super.getPortalCooldown();}
	}
	public void setVelocity(double par1, double par3, double par5) {
		{super.setVelocity(par1, par3, par5);}
		if(theEntity != null){theEntity.setVelocity(par1, par3, par5);}
	}
	public boolean isBurning() {
		if(theEntity != null){return theEntity.isBurning();}else{return super.isBurning();}
	}
	public boolean isRiding() {
		if(theEntity != null){return theEntity.isRiding();}else{return super.isRiding();}
	}
	public boolean isSneaking() {
		if(theEntity != null){return theEntity.isSneaking();}else{return super.isSneaking();}
	}
	public void setSneaking(boolean par1) {
		if(theEntity != null){theEntity.setSneaking(par1);}else{super.setSneaking(par1);}
	}
	public boolean isSprinting() {
		if(theEntity != null){return theEntity.isSprinting();}else{return super.isSprinting();}
	}
	public boolean isInvisible() {
		if(theEntity != null){return theEntity.isInvisible();}else{return super.isInvisible();}
	}
	public boolean func_98034_c(EntityPlayer par1EntityPlayer) {
		if(theEntity != null){return theEntity.func_98034_c(par1EntityPlayer);}else{return super.func_98034_c(par1EntityPlayer);}
	}
	public void setInvisible(boolean par1) {
		if(theEntity != null){theEntity.setInvisible(par1);}else{super.setInvisible(par1);}
	}
	public boolean isEating() {
		if(theEntity != null){return theEntity.isEating();}else{return super.isEating();}
	}
	public void setEating(boolean par1) {
		if(theEntity != null){theEntity.setEating(par1);}else{super.setEating(par1);}
	}
	protected boolean getFlag(int par1) {
		if(theEntity != null){return theEntity.getFlag(par1);}else{return super.getFlag(par1);}
	}
	protected void setFlag(int par1, boolean par2) {
		if(theEntity != null){theEntity.setFlag(par1, par2);}else{super.setFlag(par1, par2);}
	}
	public int getAir() {
		if(theEntity != null){return theEntity.getAir();}else{return super.getAir();}
	}
	public void setAir(int par1) {
		if(theEntity != null){theEntity.setAir(par1);}else{super.setAir(par1);}
	}
	public void onStruckByLightning(EntityLightningBolt par1EntityLightningBolt) {
		if(theEntity != null){theEntity.onStruckByLightning(par1EntityLightningBolt);}else{super.onStruckByLightning(par1EntityLightningBolt);}
	}
	public void onKillEntity(EntityLivingBase par1EntityLivingBase) {
		if(theEntity != null){theEntity.onKillEntity(par1EntityLivingBase);}else{super.onKillEntity(par1EntityLivingBase);}
	}
	protected boolean pushOutOfBlocks(double par1, double par3, double par5) {
		if(theEntity != null){return theEntity.pushOutOfBlocks(par1, par3, par5);}else{return super.pushOutOfBlocks(par1, par3, par5);}
	}
	public void setInWeb() {
		if(theEntity != null){theEntity.setInWeb();}else{super.setInWeb();}
	}
	public Entity[] getParts() {
		if(theEntity != null){return theEntity.getParts();}else{return super.getParts();}
	}
	public boolean isEntityEqual(Entity par1Entity) {
		if(theEntity != null){return theEntity.isEntityEqual(par1Entity);}else{return super.isEntityEqual(par1Entity);}
	}
	public boolean canAttackWithItem() {
		if(theEntity != null){return theEntity.canAttackWithItem();}else{return super.canAttackWithItem();}
	}
	public boolean func_85031_j(Entity par1Entity) {
		if(theEntity != null){return theEntity.func_85031_j(par1Entity);}else{return super.func_85031_j(par1Entity);}
	}
	public String toString() {
		if(theEntity != null){return theEntity.toString();}else{return super.toString();}
	}
	public boolean isEntityInvulnerable() {
		if(theEntity != null){return theEntity.isEntityInvulnerable();}else{return super.isEntityInvulnerable();}
	}
	public void copyLocationAndAnglesFrom(Entity par1Entity) {
		if(theEntity != null){theEntity.copyLocationAndAnglesFrom(par1Entity);}else{super.copyLocationAndAnglesFrom(par1Entity);}
	}
	public void copyDataFrom(Entity par1Entity, boolean par2) {
		if(theEntity != null){theEntity.copyDataFrom(par1Entity, par2);}else{super.copyDataFrom(par1Entity, par2);}
	}
	public void travelToDimension(int par1) {
		if(theEntity != null){theEntity.travelToDimension(par1);}else{super.travelToDimension(par1);}
	}
	public float func_82146_a(Explosion par1Explosion, World par2World, int par3, int par4, int par5, Block par6Block) {
		if(theEntity != null){return theEntity.func_82146_a(par1Explosion, par2World, par3, par4, par5, par6Block);}else{return super.func_82146_a(par1Explosion, par2World, par3, par4, par5, par6Block);}
	}
	public boolean func_96091_a(Explosion par1Explosion, World par2World, int par3, int par4, int par5, int par6, float par7) {
		if(theEntity != null){return theEntity.func_96091_a(par1Explosion, par2World, par3, par4, par5, par6, par7);}else{return super.func_96091_a(par1Explosion, par2World, par3, par4, par5, par6, par7);}
	}
	public int getTeleportDirection() {
		if(theEntity != null){return theEntity.getTeleportDirection();}else{return super.getTeleportDirection();}
	}
	public boolean doesEntityNotTriggerPressurePlate() {
		if(theEntity != null){return theEntity.doesEntityNotTriggerPressurePlate();}else{return super.doesEntityNotTriggerPressurePlate();}
	}
	public void func_85029_a(CrashReportCategory par1CrashReportCategory) {
		if(theEntity != null){theEntity.func_85029_a(par1CrashReportCategory);}else{super.func_85029_a(par1CrashReportCategory);}
	}
	public boolean canRenderOnFire() {
		if(theEntity != null){return theEntity.canRenderOnFire();}else{return super.canRenderOnFire();}
	}
	public UUID func_110124_au() {
		if(theEntity != null){return theEntity.func_110124_au();}else{return super.func_110124_au();}
	}
	public boolean func_96092_aw() {
		if(theEntity != null){return theEntity.func_96092_aw();}else{return super.func_96092_aw();}
	}
	public String getTranslatedEntityName() {
		if(theEntity != null){return theEntity.getTranslatedEntityName();}else{return super.getTranslatedEntityName();}
	}
	public NBTTagCompound getEntityData() {
		if(theEntity != null){return theEntity.getEntityData();}else{return super.getEntityData();}
	}
	public boolean shouldRiderSit() {
		if(theEntity != null){return theEntity.shouldRiderSit();}else{return super.shouldRiderSit();}
	}
	public ItemStack getPickedResult(MovingObjectPosition target) {
		if(theEntity != null){return theEntity.getPickedResult(target);}else{return super.getPickedResult(target);}
	}
	public UUID getPersistentID() {
		if(theEntity != null){return theEntity.getPersistentID();}else{return super.getPersistentID();}
	}
	public boolean shouldRenderInPass(int pass) {
		if(theEntity != null){return theEntity.shouldRenderInPass(pass);}else{return super.shouldRenderInPass(pass);}
	}
	public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
		if(theEntity != null){return theEntity.isCreatureType(type, forSpawnCount);}else{return super.isCreatureType(type, forSpawnCount);}
	}
	public String registerExtendedProperties(String identifier, IExtendedEntityProperties properties) {
		if(theEntity != null){return theEntity.registerExtendedProperties(identifier, properties);}else{return super.registerExtendedProperties(identifier, properties);}
	}
	public IExtendedEntityProperties getExtendedProperties(String identifier) {
		if(theEntity != null){return theEntity.getExtendedProperties(identifier);}else{return super.getExtendedProperties(identifier);}
	}
	public boolean canRiderInteract() {
		if(theEntity != null){return theEntity.canRiderInteract();}else{return super.canRiderInteract();}
	}

	//TODO HERE
	//--------ENTITYLIVING METHODS BELOW

	/*protected void func_110147_ax() {
		if(theEntityLiving != null){theEntityLiving.func_110147_ax();}else{super.func_110147_ax();}
	}
	public EntityLookHelper getLookHelper() {
		if(theEntityLiving != null){return theEntityLiving.getLookHelper();}else{return super.getLookHelper();}
	}
	public EntityMoveHelper getMoveHelper() {
		if(theEntityLiving != null){return theEntityLiving.getMoveHelper();}else{return super.getMoveHelper();}
	}
	public EntityJumpHelper getJumpHelper() {
		if(theEntityLiving != null){return theEntityLiving.getJumpHelper();}else{return super.getJumpHelper();}
	}
	public PathNavigate getNavigator() {
		if(theEntityLiving != null){return theEntityLiving.getNavigator();}else{return super.getNavigator();}
	}
	public EntitySenses getEntitySenses() {
		if(theEntityLiving != null){return theEntityLiving.getEntitySenses();}else{return super.getEntitySenses();}
	}
	public EntityLivingBase getAttackTarget() {
		if(theEntityLiving != null){return theEntityLiving.getAttackTarget();}else{return super.getAttackTarget();}
	}
	public void setAttackTarget(EntityLivingBase par1EntityLivingBase) {
		if(theEntityLiving != null){theEntityLiving.setAttackTarget(par1EntityLivingBase);}else{super.setAttackTarget(par1EntityLivingBase);}
	}
	public boolean canAttackClass(Class par1Class) {
		if(theEntityLiving != null){return theEntityLiving.canAttackClass(par1Class);}else{return super.canAttackClass(par1Class);}
	}
	public void eatGrassBonus() {
		if(theEntityLiving != null){theEntityLiving.eatGrassBonus();}else{super.eatGrassBonus();}
	}
	protected void entityInit() {
		if(theEntityLiving != null){theEntityLiving.entityInit();}else{super.entityInit();}
	}
	public int getTalkInterval() {
		if(theEntityLiving != null){return theEntityLiving.getTalkInterval();}else{return super.getTalkInterval();}
	}
	public void playLivingSound() {
		if(theEntityLiving != null){theEntityLiving.playLivingSound();}else{super.playLivingSound();}
	}
	public void onEntityUpdate() {
		if(theEntityLiving != null){theEntityLiving.onEntityUpdate();}else{super.onEntityUpdate();}
	}
	protected int getExperiencePoints(EntityPlayer par1EntityPlayer) {
		if(theEntityLiving != null){return theEntityLiving.getExperiencePoints(par1EntityPlayer);}else{return super.getExperiencePoints(par1EntityPlayer);}
	}
	public void spawnExplosionParticle() {
		if(theEntityLiving != null){theEntityLiving.spawnExplosionParticle();}else{super.spawnExplosionParticle();}
	}
	protected float func_110146_f(float par1, float par2) {
		if(theEntityLiving != null){return theEntityLiving.func_110146_f(par1, par2);}else{return super.func_110146_f(par1, par2);}
	}
	protected String getLivingSound() {
		if(theEntityLiving != null){return theEntityLiving.getLivingSound();}else{return super.getLivingSound();}
	}
	protected int getDropItemId() {
		if(theEntityLiving != null){return theEntityLiving.getDropItemId();}else{return super.getDropItemId();}
	}
	protected void dropFewItems(boolean par1, int par2) {
		if(theEntityLiving != null){theEntityLiving.dropFewItems(par1, par2);}else{super.dropFewItems(par1, par2);}
	}
	public void setMoveForward(float par1) {
		{super.setMoveForward(par1);}
		if(theEntityLiving != null){theEntityLiving.setMoveForward(par1);}
	}
	public void setAIMoveSpeed(float par1) {
		{super.setAIMoveSpeed(par1);}
		if(theEntityLiving != null){theEntityLiving.setAIMoveSpeed(par1);}
	}
	protected boolean isAIEnabled() {
		if(theEntityLiving != null){return theEntityLiving.isAIEnabled();}else{return super.isAIEnabled();}
	}
	protected boolean canDespawn() {
		if(theEntityLiving != null){return theEntityLiving.canDespawn();}else{return super.canDespawn();}
	}
	protected void despawnEntity() {
		super.despawnEntity();
		//		if(theEntityLiving != null){theEntityLiving.despawnEntity();}else{super.despawnEntity();}
	}
	protected void updateAITasks() {
		if(theEntityLiving != null){theEntityLiving.updateAITasks();}else{super.updateAITasks();}
	}
	protected void updateEntityActionState() {
		if(theEntityLiving != null){theEntityLiving.updateEntityActionState();}else{super.updateEntityActionState();}
	}
	public int getVerticalFaceSpeed() {
		if(theEntityLiving != null){return theEntityLiving.getVerticalFaceSpeed();}else{return super.getVerticalFaceSpeed();}
	}
	public void faceEntity(Entity par1Entity, float par2, float par3) {
		if(theEntityLiving != null){theEntityLiving.faceEntity(par1Entity, par2, par3);}else{super.faceEntity(par1Entity, par2, par3);}
	}
	public boolean getCanSpawnHere() {
		if(theEntityLiving != null){return theEntityLiving.getCanSpawnHere();}else{return super.getCanSpawnHere();}
	}
	public float getRenderSizeModifier() {
		if(theEntityLiving != null){return theEntityLiving.getRenderSizeModifier();}else{return super.getRenderSizeModifier();}
	}
	public int getMaxSpawnedInChunk() {
		if(theEntityLiving != null){return theEntityLiving.getMaxSpawnedInChunk();}else{return super.getMaxSpawnedInChunk();}
	}
	public int func_82143_as() {
		if(theEntityLiving != null){return theEntityLiving.func_82143_as();}else{return super.func_82143_as();}
	}
	public ItemStack getHeldItem() {
		if(theEntityLiving != null){return theEntityLiving.getHeldItem();}else{return super.getHeldItem();}
	}
	public ItemStack getCurrentItemOrArmor(int par1) {
		if(theEntityLiving != null){return theEntityLiving.getCurrentItemOrArmor(par1);}else{return super.getCurrentItemOrArmor(par1);}
	}
	public ItemStack func_130225_q(int i) {
		if(theEntityLiving != null){return theEntityLiving.func_130225_q(i);}else{return super.func_130225_q(i);}
	}
	public void setCurrentItemOrArmor(int par1, ItemStack par2ItemStack) {
		if(theEntityLiving != null){theEntityLiving.setCurrentItemOrArmor(par1, par2ItemStack);}else{super.setCurrentItemOrArmor(par1, par2ItemStack);}
	}
	public ItemStack[] getLastActiveItems() {
		if(theEntityLiving != null){return theEntityLiving.getLastActiveItems();}else{return super.getLastActiveItems();}
	}
	protected void dropEquipment(boolean par1, int par2) {
		if(theEntityLiving != null){theEntityLiving.dropEquipment(par1, par2);}else{super.dropEquipment(par1, par2);}
	}
	protected void addRandomArmor() {
		if(theEntityLiving != null){theEntityLiving.addRandomArmor();}else{super.addRandomArmor();}
	}
	protected void enchantEquipment() {
		if(theEntityLiving != null){theEntityLiving.enchantEquipment();}else{super.enchantEquipment();}
	}
	public EntityLivingData func_110161_a(EntityLivingData par1EntityLivingData) {
		if(theEntityLiving != null){return theEntityLiving.func_110161_a(par1EntityLivingData);}else{return super.func_110161_a(par1EntityLivingData);}
	}
	public boolean canBeSteered() {
		if(theEntityLiving != null){return theEntityLiving.canBeSteered();}else{return super.canBeSteered();}
	}
	public String getEntityName() {
		if(theEntityLiving != null){return theEntityLiving.getEntityName();}else{return super.getEntityName();}
	}
	public void func_110163_bv() {
		if(theEntityLiving != null){theEntityLiving.func_110163_bv();}else{super.func_110163_bv();}
	}
	public void setCustomNameTag(String par1Str) {
		if(theEntityLiving != null){theEntityLiving.setCustomNameTag(par1Str);}else{super.setCustomNameTag(par1Str);}
	}
	public String getCustomNameTag() {
		if(theEntityLiving != null){return theEntityLiving.getCustomNameTag();}else{return super.getCustomNameTag();}
	}
	public boolean hasCustomNameTag() {
		if(theEntityLiving != null){return theEntityLiving.hasCustomNameTag();}else{return super.hasCustomNameTag();}
	}
	public void setAlwaysRenderNameTag(boolean par1) {
		if(theEntityLiving != null){theEntityLiving.setAlwaysRenderNameTag(par1);}else{super.setAlwaysRenderNameTag(par1);}
	}
	public boolean getAlwaysRenderNameTag() {
		if(theEntityLiving != null){return theEntityLiving.getAlwaysRenderNameTag();}else{return super.getAlwaysRenderNameTag();}
	}
	public boolean getAlwaysRenderNameTagForRender() {
		if(theEntityLiving != null){return theEntityLiving.getAlwaysRenderNameTagForRender();}else{return super.getAlwaysRenderNameTagForRender();}
	}
	public void setEquipmentDropChance(int par1, float par2) {
		if(theEntityLiving != null){theEntityLiving.setEquipmentDropChance(par1, par2);}else{super.setEquipmentDropChance(par1, par2);}
	}
	public boolean canPickUpLoot() {
		if(theEntityLiving != null){return theEntityLiving.canPickUpLoot();}else{return super.canPickUpLoot();}
	}
	public void setCanPickUpLoot(boolean par1) {
		if(theEntityLiving != null){theEntityLiving.setCanPickUpLoot(par1);}else{super.setCanPickUpLoot(par1);}
	}
	public boolean func_104002_bU() {
		if(theEntityLiving != null){return theEntityLiving.func_104002_bU();}else{return super.func_104002_bU();}
	}
	protected boolean interact(EntityPlayer par1EntityPlayer) {
		if(theEntityLiving != null){return theEntityLiving.interact(par1EntityPlayer);}else{return super.interact(par1EntityPlayer);}
	}
	protected void func_110159_bB() {
		if(theEntityLiving != null){theEntityLiving.func_110159_bB();}else{super.func_110159_bB();}
	}
	public void func_110160_i(boolean par1, boolean par2) {
		if(theEntityLiving != null){theEntityLiving.func_110160_i(par1, par2);}else{super.func_110160_i(par1, par2);}
	}
	public boolean func_110164_bC() {
		if(theEntityLiving != null){return theEntityLiving.func_110164_bC();}else{return super.func_110164_bC();}
	}
	public boolean func_110167_bD() {
		if(theEntityLiving != null){return theEntityLiving.func_110167_bD();}else{return super.func_110167_bD();}
	}
	public Entity func_110166_bE() {
		if(theEntityLiving != null){return theEntityLiving.func_110166_bE();}else{return super.func_110166_bE();}
	}
	public void func_110162_b(Entity par1Entity, boolean par2) {
		if(theEntityLiving != null){theEntityLiving.func_110162_b(par1Entity, par2);}else{super.func_110162_b(par1Entity, par2);}
	}*/


	static ArrayList<Class> excludeSizeChange = new ArrayList<Class>();

	static{
		excludeSizeChange.add(EntityDragon.class);
	}
}
